<?php
include 'conexioncrud.php';
session_start();

$iduser = $_SESSION['id_usuarioo'];

// Capturar la variable client2 desde la URL
$client2 = isset($_GET['client']) ? mysqli_real_escape_string($con, $_GET['client']) : 'No se recibió client2';
// URL de retorno
$urlReturn = "https://hostalriberasdelcruces.cl/php/tabla_mis_reservas.php?client=" . urlencode($client2);

// Verifica que la solicitud sea POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtiene el cuerpo de la solicitud
    $rawData = file_get_contents("php://input");

    // Decodifica el JSON recibido
    $data = json_decode($rawData, true);

    // Verifica que la decodificación fue exitosa
    if ($data !== null) {
        // Procesar la información recibida
        $orderId = mysqli_real_escape_string($con, $data['commerceOrder']);
        $status = mysqli_real_escape_string($con, $data['status']);

        // Log detalles de la transacción
        $logDescripcion = "Order ID: $orderId, Status: $status, Client2: $client2";
        $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('$logDescripcion')";
        if (!mysqli_query($con, $sql_logs)) {
            error_log("Error al registrar los logs: " . mysqli_error($con));
        }

        // Acciones adicionales según tus necesidades...

        // Responder a Flow para confirmar la recepción de la notificación
        http_response_code(200);
        echo json_encode(['status' => 'ok']);
    } else {
        // Manejo de error si no se puede decodificar el JSON
        $logDescripcion = "Error: No se pudo decodificar el JSON. Client2: $client2";
        $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('$logDescripcion')";
        if (!mysqli_query($con, $sql_logs)) {
            error_log("Error al registrar los logs: " . mysqli_error($con));
        }

        // Redirigir a la URL de retorno
        header("Location: $urlReturn");
        //exit();
    }
} else {
    // Manejo de error si la solicitud no es POST
    $logDescripcion = "Error: Se espera una solicitud POST. Client2: $client2";
    $sql_logs = "INSERT INTO logs_registros (descripcion) VALUES ('$logDescripcion')";
    if (!mysqli_query($con, $sql_logs)) {
        error_log("Error al registrar los logs: " . mysqli_error($con));
    }

    http_response_code(405); // Method Not Allowed
    echo "Error: Se espera una solicitud POST.";
    // Redirigir a la URL de retorno
    header("Location: $urlReturn");
    //exit();
}
?>
